<?php

namespace DiviEssential\PopupPro\Partials;

defined( 'ABSPATH' ) || die();

Class DataManger{

    public function layout_values() {
        return array(
            'box'        => esc_html__( 'Box Width', 'dnxte-divi-essential' ),
            'full_width' => esc_html__( 'Full Width', 'dnxte-divi-essential' ),
        );
    }

    public function close_btn_position_option() {
        return array(
            'top_right'     => esc_html__( 'Top Right', 'dnxte-divi-essential' ),
            'top_center'    => esc_html__( 'Top Center', 'dnxte-divi-essential' ),
            'top_left'      => esc_html__( 'Top Left', 'dnxte-divi-essential' ),
            'bottom_right'  => esc_html__( 'Bottom Right', 'dnxte-divi-essential' ),
            'bottom_center' => esc_html__( 'Bottom Center', 'dnxte-divi-essential' ),
            'bottom_left'   => esc_html__( 'Bottom Left', 'dnxte-divi-essential' ),
        );
    }
    public function pop_up_pro_pos_place_options() {
        return array(
            'top_left'      => esc_html__( 'Top Left', 'dnxte-divi-essential' ),
            'top_center'    => esc_html__( 'Top Center', 'dnxte-divi-essential' ),
            'top_right'     => esc_html__( 'Top Right', 'dnxte-divi-essential' ),
            'center_left'   => esc_html__( 'Center Left', 'dnxte-divi-essential' ),
            'center_center' => esc_html__( 'Center', 'dnxte-divi-essential' ),
            'center_right'  => esc_html__( 'Center Right', 'dnxte-divi-essential' ),
            'bottom_left'   => esc_html__( 'Bottom Left', 'dnxte-divi-essential' ),
            'bottom_center' => esc_html__( 'Bottom Center', 'dnxte-divi-essential' ),
            'bottom_right'  => esc_html__( 'Bottom Right', 'dnxte-divi-essential' ),
        );
    }

    public function close_animation_options() {
        return array(
            ''                          => esc_html__( 'Select', 'dnxte-divi-essential' ),
            'popup_load'                => esc_html__( 'Popup Load', 'dnxte-divi-essential' ),
            'zoom_center'               => esc_html__( 'Zoom Center', 'dnxte-divi-essential' ),
            'zoom_center_rev'           => esc_html__( 'Zoom Center Rev', 'dnxte-divi-essential' ),
            'slide_left'                => esc_html__( 'Slide Left', 'dnxte-divi-essential' ),
            'slide_left_rev'            => esc_html__( 'Slide Right Rev', 'dnxte-divi-essential' ),
            'slide_up'                  => esc_html__( 'Slide Up', 'dnxte-divi-essential' ),
            'slide_up_rev'              => esc_html__( 'Slide Up Rev', 'dnxte-divi-essential' ),
            'slide_down'                => esc_html__( 'Slide Down', 'dnxte-divi-essential' ),
            'slide_down_rev'            => esc_html__( 'Slide Down Rev', 'dnxte-divi-essential' ),
            'fade_in_rev'               => esc_html__( 'Fade In Rev', 'dnxte-divi-essential' ),
            'animate_bounce'            => esc_html__( 'Bounce', 'dnxte-divi-essential' ),
            'animate_shakeX'            => esc_html__( 'ShakeX', 'dnxte-divi-essential' ),
            'animate_shakeY'            => esc_html__( 'ShakeY', 'dnxte-divi-essential' ),
            'animate_bounceIn'          => esc_html__( 'BounceIn', 'dnxte-divi-essential' ),
            'animate_bounceInUp'        => esc_html__( 'BounceInUp', 'dnxte-divi-essential' ),
            'animate_fadeInDown'        => esc_html__( 'FadeInDown', 'dnxte-divi-essential' ),
            'animate_fadeInDownBig'     => esc_html__( 'FadeInDownBig', 'dnxte-divi-essential' ),
            'animate_fadeInRight'       => esc_html__( 'FadeInRight', 'dnxte-divi-essential' ),
            'animate_fadeInUpBig'       => esc_html__( 'FadeInUpBig', 'dnxte-divi-essential' ),
            'animate_fadeOut'           => esc_html__( 'FadeOut', 'dnxte-divi-essential' ),
            'animate_fadeOutDown'       => esc_html__( 'FadeOutDown', 'dnxte-divi-essential' ),
            'animate_fadeOutLeft'       => esc_html__( 'FadeOutLeft', 'dnxte-divi-essential' ),
            'animate_fadeOutRight'      => esc_html__( 'FadeOutRight', 'dnxte-divi-essential' ),
            'animate_fadeOutUp'         => esc_html__( 'FadeOutUp', 'dnxte-divi-essential' ),
            'animate_lightSpeedInLeft'  => esc_html__( 'LightSpeedInLeft', 'dnxte-divi-essential' ),
            'animate_lightSpeedOutRight'=> esc_html__( 'LightSpeedOutRight', 'dnxte-divi-essential' ),
            'animate_lightSpeedOutLeft' => esc_html__( 'LightSpeedOutLeft', 'dnxte-divi-essential' ),
            'animate_zoomOut'           => esc_html__( 'zoomOut', 'dnxte-divi-essential' ),
            'animate_zoomOutDown'       => esc_html__( 'zoomOutDown', 'dnxte-divi-essential' ),
        );
    }

    public function open_animation_options() {
        return array(
            ''                          => esc_html__( 'Select', 'dnxte-divi-essential' ),
            'popup_load'                => esc_html__( 'Popup Load', 'dnxte-divi-essential' ),
            'zoom_center'               => esc_html__( 'Zoom Center', 'dnxte-divi-essential' ),
            'zoom_center_rev'           => esc_html__( 'Zoom Center Rev', 'dnxte-divi-essential' ),
            'slide_left'                => esc_html__( 'Slide Left', 'dnxte-divi-essential' ),
            'slide_left_rev'            => esc_html__( 'Slide Right Rev', 'dnxte-divi-essential' ),
            'slide_up'                  => esc_html__( 'Slide Up', 'dnxte-divi-essential' ),
            'slide_up_rev'              => esc_html__( 'Slide Up Rev', 'dnxte-divi-essential' ),
            'slide_down'                => esc_html__( 'Slide Down', 'dnxte-divi-essential' ),
            'slide_down_rev'            => esc_html__( 'Slide Down Rev', 'dnxte-divi-essential' ),
            'fade_in_rev'               => esc_html__( 'Fade In Rev', 'dnxte-divi-essential' ),
            'animate_bounce'            => esc_html__( 'Bounce', 'dnxte-divi-essential' ),
            'animate_pulse'             => esc_html__( 'Pulse', 'dnxte-divi-essential' ),
            'animate_shakeX'            => esc_html__( 'ShakeX', 'dnxte-divi-essential' ),
            'animate_shakeY'            => esc_html__( 'ShakeY', 'dnxte-divi-essential' ),
            'animate_headShake'         => esc_html__( 'headShake', 'dnxte-divi-essential' ),
            'animate_heartBeat'         => esc_html__( 'heartBeat', 'dnxte-divi-essential' ),
            'animate_bounceIn'          => esc_html__( 'BounceIn', 'dnxte-divi-essential' ),
            'animate_bounceInDown'      => esc_html__( 'BounceInDown', 'dnxte-divi-essential' ),
            'animate_bounceInLeft'      => esc_html__( 'BounceInLeft', 'dnxte-divi-essential' ),
            'animate_bounceInRight'     => esc_html__( 'BounceInRight', 'dnxte-divi-essential' ),
            'animate_bounceInUp'        => esc_html__( 'BounceInUp', 'dnxte-divi-essential' ),
            'animate_fadeInDown'        => esc_html__( 'FadeInDown', 'dnxte-divi-essential' ),
            'animate_fadeInDownBig'     => esc_html__( 'FadeInDownBig', 'dnxte-divi-essential' ),
            'animate_fadeInLeft'        => esc_html__( 'FadeInLeft', 'dnxte-divi-essential' ),
            'animate_fadeInLeftBig'     => esc_html__( 'FadeInLeftBig', 'dnxte-divi-essential' ),
            'animate_fadeInRight'       => esc_html__( 'FadeInRight', 'dnxte-divi-essential' ),
            'animate_fadeInLeftBig'     => esc_html__( 'FadeInLeftBig', 'dnxte-divi-essential' ),
            'animate_fadeInRightBig'    => esc_html__( 'FadeInRightBig', 'dnxte-divi-essential' ),
            'animate_fadeInUpBig'       => esc_html__( 'FadeInUpBig', 'dnxte-divi-essential' ),
            'animate_fadeOut'           => esc_html__( 'FadeOut', 'dnxte-divi-essential' ),
            'animate_fadeOutDown'       => esc_html__( 'FadeOutDown', 'dnxte-divi-essential' ),
            'animate_fadeOutLeft'       => esc_html__( 'FadeOutLeft', 'dnxte-divi-essential' ),
            'animate_fadeOutRight'      => esc_html__( 'FadeOutRight', 'dnxte-divi-essential' ),
            'animate_fadeOutUp'         => esc_html__( 'FadeOutUp', 'dnxte-divi-essential' ),
            'animate_flipInX'           => esc_html__( 'FlipInX', 'dnxte-divi-essential' ),
            'animate_flipInY'           => esc_html__( 'FlipInY', 'dnxte-divi-essential' ),
            'animate_lightSpeedInRight' => esc_html__( 'LightSpeedInRight', 'dnxte-divi-essential' ),
            'animate_lightSpeedInLeft'  => esc_html__( 'LightSpeedInLeft', 'dnxte-divi-essential' ),
            'animate_lightSpeedOutRight'=> esc_html__( 'LightSpeedOutRight', 'dnxte-divi-essential' ),
            'animate_lightSpeedOutLeft' => esc_html__( 'LightSpeedOutLeft', 'dnxte-divi-essential' ),
            'animate_zoomIn'            => esc_html__( 'zoomIn', 'dnxte-divi-essential' ),
            'animate_zoomInDown'        => esc_html__( 'zoomInDown', 'dnxte-divi-essential' ),
            'animate_zoomOut'           => esc_html__( 'zoomOut', 'dnxte-divi-essential' ),
            'animate_zoomOutDown'       => esc_html__( 'zoomOutDown', 'dnxte-divi-essential' ),
        );
    }
    public function get_popup_data($id) {
        $meta_data = array(
            'dnxte_popup-active'                    => 'true',
            'dnxteppro_sub_triggering_settings'     => '',
            'dnxte_manual_custom_css_selector'      => '',
            'dnxte_closing_css_selector'            => '',
            'dnxte_remove_link'                     => 'true',
            'dnxte_close_overlay_click'             => 'true',
            'dnxte_clickable_under_overlay'         => 'true',
            'dnxte_prevent_page_scrolling'          => 'true',
            'dnxte_close_clicking_back_button'      => 'true',
            'trigger_autotrigger-periodicity'       => 'every_time',
            'trigger_autotrigger-periodicity-hours' => '24',
            'dnxte_auto_trigger_activity'           => 'always',
            'dnxte_auto_trigger_activity_certain_perion_from' => '',
            'dnxte_auto_trigger_activity_certain_perion_to'   => '',
            'trigger_on_load-delay-start'        => '0',
            'trigger_on_load-delay-end'          => '0',
            'dnxte_trigger_on_scroll_offset'           => '0',
            'dnxte_trigger_on_scroll_offset_units'     => 'px',
            'dnxte_trigger_on_inactivity_delay'        => '0',
            'dnxte_popup_pro_title'             => '',
            'dnxte_popup_pro_overlay_bg_color'  => '',
            'dnxte_popup_pro_overlay_zindex'    => '',
            'dnxte_pp_enable_overlay_blur'      => true,
            'dnxte_custom_hide_close_btn'       => false,
            'dnxte_custom_close_btn_outside'    => false,
            'open_animation_name'               => '',
            'closing_animation_name'            => '',
            'dnxte_popup_pro_close_btn_color'   => '',
            'dnxte_popup_pro_close_btn_bg_color'   => '',
            'dnxte_popup_pro_close_btn_icon_size'   => '',
            'dnxte_popup_pro_close_btn_bottom_padding'   => '',
            'dnxte_popup_pro_close_btn_left_padding'   => '',
            'dnxte_popup_pro_close_btn_top_padding'   => '',
            'dnxte_popup_layout'   => '',
            'dnxte_popup_pro_close_btn_bottom_left_border_radius'   => '',
            'dnxte_popup_pro_close_btn_bottom_right_border_radius'   => '',
            'dnxte_popup_pro_close_btn_top_right_border_radius'   => '',
            'dnxte_popup_pro_close_btn_top_left_border_radius'   => '',
            'dnxte_popup_pro_close_btn_border_radius'   => '',
            'dnxte_popup_pro_close_btn_right_padding'   => '',
            'dnxte_popup_pro_close_btn_top_margin'   => '',
            'dnxte_popup_pro_close_btn_bottom_margin'   => '',
            'dnxte_popup_pro_close_btn_left_margin'   => '',
            'dnxte_popup_pro_close_btn_right_margin'   => '',
            'dnxte_popup_pro_place_name'   => '',
            'dnxte_pop_up_pro_close_btn_position'   => '',
        );

        if (empty($id)) {
            return $meta_data;
        }

        foreach ($meta_data as $key => $value) {
            $meta_data[$key] = get_post_meta($id, $key, true);
        }

        return $meta_data;
    }
}