<?php defined( 'ABSPATH' ) || die();

use DiviEssential\PopupPro\Partials\DataManger; 

if (file_exists( dirname( __FILE__ ) . '/partials/data-manager.php' )) {
  include_once dirname( __FILE__ ) . '/partials/data-manager.php';
}
$data_manager = new DataManger();

$meta_data = $data_manager->get_popup_data( get_the_ID() );

$dnxte_tabs = array(
  'general'       => esc_html__('General', 'dnxte-divi-essential'),
  'customization' => esc_html__('Customization', 'dnxte-divi-essential'),
  'display'       => esc_html__('Display', 'dnxte-divi-essential'),
); 
?>

<div id="dnxte-ppro_setting-navigation">
	<ul class="dnxte-ppro_setting-nav-tab-wrapper trigger-effect-tabs">
    <?php
      foreach ( $dnxte_tabs as $key => $value) {
        $active = $key == 'general' ?  'active' : '';
        ?>
        <li data-tab-target="#dnxte_<?php echo esc_attr($key) ?>" class="<?php echo esc_attr($active) ?> dnxte-ppro-tabs">
          <a class="dnxte-ppro_setting-nav-tab dnxte-ppro-tab">
            <?php echo esc_html__($value) ?>
          </a>
        </li>
        <?php
      }
    ?>
  </ul>

  <div class="tab-content">
    <?php
      foreach ( $dnxte_tabs as $key => $value) {
        $active = $key == 'general' ?  'active' : '';
        ?>
        <div data-tab-content id="dnxte_<?php echo esc_attr($key) ?>" class="<?php echo esc_attr($active) ?>">
            <?php 
              if ( file_exists( dirname( __FILE__ ) . '/partials/' . $key . '/index.php' )) {
                include  dirname( __FILE__ ) . '/partials/'.  $key. '/index.php';
              }
            ?>
        </div>
        <?php
      }
    ?>
  </div>

</div>
